﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Thomas_Erdoesi.Game_Analyzer
{
    public class CtNamePacket
    {
        private string HiScoreName;

        public CtNamePacket(string HiScoreName)
        {
            this.HiScoreName = HiScoreName;
        }

        public byte[] ToByteArray()
        {
            byte[] PackageHeader = new ASCIIEncoding().GetBytes("ctname");
            byte[] PackageContent = new UTF8Encoding().GetBytes(HiScoreName);

            byte[] bytes = new byte[38];

            for (int Index = 0; Index < bytes.Length; Index++)
                bytes[Index] = 0;

            for (int Index = 0; Index < PackageHeader.Length; Index++)
                bytes[Index] = PackageHeader[Index];

            for (int Index = 0; Index < PackageContent.Length && Index < 38; Index++)
                bytes[Index + PackageHeader.Length] = PackageContent[Index];

            return bytes;
        }
    }
}
